/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.classes;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.collections4.list.SetUniqueList;

public class ImportVisitor
extends EmptyVisitor {
    private final List<String> imports;
    private final JavaClass javaClass;
    private static final Pattern QUALIFIED_IMPORT_PATTERN = Pattern.compile("L([a-zA-Z][a-zA-Z0-9\\.]+);");
    private static final Pattern VALID_UTF8_PATTERN = Pattern.compile("^[\\(\\)\\[A-Za-z0-9;/]+$");

    public ImportVisitor(JavaClass javaClass) {
        this.javaClass = javaClass;
        this.imports = SetUniqueList.setUniqueList(new ArrayList());
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void visitConstantClass(ConstantClass constantClass) {
        Matcher mat;
        String name = constantClass.getBytes(this.javaClass.getConstantPool());
        if (name.indexOf(47) == -1) {
            return;
        }
        if ((name = name.replace('/', '.')).endsWith(".class")) {
            name = name.substring(0, name.length() - 6);
        }
        if ((mat = QUALIFIED_IMPORT_PATTERN.matcher(name)).find()) {
            this.imports.add(mat.group(1));
        } else {
            this.imports.add(name);
        }
    }

    public void visitConstantUtf8(ConstantUtf8 constantUtf8) {
        String ret = constantUtf8.getBytes().trim();
        if (ret.length() <= 0) {
            return;
        }
        if (!VALID_UTF8_PATTERN.matcher(ret).matches()) {
            return;
        }
        if (ret.indexOf(47) == -1) {
            return;
        }
        if (ret.charAt(0) == '/') {
            return;
        }
        if ((ret = ret.replace('/', '.')).contains("..")) {
            return;
        }
        Matcher mat = QUALIFIED_IMPORT_PATTERN.matcher(ret);
        char prefix = ret.charAt(0);
        if (prefix == '(') {
            while (mat.find()) {
                this.imports.add(mat.group(1));
            }
        } else if (mat.find()) {
            this.imports.add(mat.group(1));
        } else {
            this.imports.add(ret);
        }
    }
}

