/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecK;
import org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecL;

class PolyVecMatrix {
    private final int dilithiumK;
    private final int dilithiumL;
    private final PolyVecL[] mat;

    public PolyVecMatrix(DilithiumEngine dilithiumEngine) {
        this.dilithiumK = dilithiumEngine.getDilithiumK();
        this.dilithiumL = dilithiumEngine.getDilithiumL();
        this.mat = new PolyVecL[this.dilithiumK];
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.mat[j] = new PolyVecL(dilithiumEngine);
        }
    }

    public void pointwiseMontgomery(PolyVecK polyVecK, PolyVecL polyVecL) {
        for (int j = 0; j < this.dilithiumK; ++j) {
            polyVecK.getVectorIndex(j).pointwiseAccountMontgomery(this.mat[j], polyVecL);
        }
    }

    public void expandMatrix(byte[] byArray) {
        for (int j = 0; j < this.dilithiumK; ++j) {
            for (int k = 0; k < this.dilithiumL; ++k) {
                this.mat[j].getVectorIndex(k).uniformBlocks(byArray, (short)((j << 8) + k));
            }
        }
    }

    private String addString() {
        String string = "[";
        for (int j = 0; j < this.dilithiumK; ++j) {
            string = string + "Outer Matrix " + j + " [";
            string = string + this.mat[j].toString();
            string = j == this.dilithiumK - 1 ? string + "]\n" : string + "],\n";
        }
        string = string + "]\n";
        return string;
    }

    public String toString(String string) {
        return string.concat(": \n" + this.addString());
    }
}

