/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.HazelcastDataConnection;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.HazelcastInstanceProxy;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetService;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.function.RunnableEx;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.exception.JetDisabledException;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.FunctionsSerializerHook;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.MemoizingSupplier;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Util {
    public static final String CONFIG_OVERRIDE_WARNING = "(for Hazelcast embedded, works only when loading config via Config.load)";
    public static final String CONFIG_OVERRIDE_WARNING_ENV = "(recommended when running container image. For Hazelcast embedded, works only when loading config via Config.load)";
    public static final String CONFIG_CHANGE_TEMPLATE = "  - Change member config using Java API: %s\n  - Change XML/YAML configuration property: Set %s\n  - Add system property: %s (for Hazelcast embedded, works only when loading config via Config.load)\n  - Add environment variable: %s (recommended when running container image. For Hazelcast embedded, works only when loading config via Config.load)";
    public static final String JET_IS_DISABLED_MESSAGE = "The Jet engine is disabled.\nTo enable the Jet engine on the members, do one of the following:\n" + String.format("  - Change member config using Java API: %s\n  - Change XML/YAML configuration property: Set %s\n  - Add system property: %s (for Hazelcast embedded, works only when loading config via Config.load)\n  - Add environment variable: %s (recommended when running container image. For Hazelcast embedded, works only when loading config via Config.load)", "config.getJetConfig().setEnabled(true)", "hazelcast.jet.enabled to true", "-Dhz.jet.enabled=true", "HZ_JET_ENABLED=true");
    public static final String JET_RESOURCE_UPLOAD_DISABLED_MESSAGE = "A job is trying to upload resources to the cluster, but this feature is disabled. Either remove the resources from the JobConfig object or enable resource upload on the members, using one of the following:\n" + String.format("  - Change member config using Java API: %s\n  - Change XML/YAML configuration property: Set %s\n  - Add system property: %s (for Hazelcast embedded, works only when loading config via Config.load)\n  - Add environment variable: %s (recommended when running container image. For Hazelcast embedded, works only when loading config via Config.load)", "config.getJetConfig().setResourceUploadEnabled(true);", "hazelcast.jet.resource-upload-enabled to true", "-Dhz.jet.resource-upload-enabled=true", "HZ_JET_RESOURCEUPLOADENABLED=true");
    private static final DateTimeFormatter LOCAL_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final Pattern TRAILING_NUMBER_PATTERN = Pattern.compile("(.*)-([0-9]+)");

    private Util() {
    }

    public static boolean isJobSuspendable(JobConfig jobConfig) {
        Boolean argument = (Boolean)jobConfig.getArgument("__jet.jobIsSuspendable");
        return argument == null || argument != false;
    }

    public static <T> Supplier<T> memoize(Supplier<T> onceSupplier) {
        return new MemoizingSupplier<T>(onceSupplier);
    }

    public static <T> Supplier<T> memoizeConcurrent(Supplier<T> onceSupplier) {
        return new ConcurrentMemoizingSupplier<T>(onceSupplier);
    }

    public static <T> T uncheckCall(@Nonnull Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw com.hazelcast.internal.util.ExceptionUtil.sneakyThrow(e);
        }
    }

    public static void uncheckRun(@Nonnull RunnableEx r) {
        r.run();
    }

    @CheckReturnValue
    public static boolean tryIncrement(AtomicInteger value, int increment, int limit) {
        int next;
        int prev;
        do {
            if ((next = (prev = value.get()) + increment) <= limit) continue;
            return false;
        } while (!value.compareAndSet(prev, next));
        return true;
    }

    public static JetService getJet(NodeEngine nodeEngine) {
        return ((JetServiceBackend)nodeEngine.getService("hz:impl:jetService")).getJet();
    }

    public static long addClamped(long a, long b) {
        long sum = a + b;
        return Util.sumHadOverflow(a, b, sum) ? (a >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE) : sum;
    }

    public static long subtractClamped(long a, long b) {
        long diff = a - b;
        return Util.diffHadOverflow(a, b, diff) ? (a >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE) : diff;
    }

    public static boolean sumHadOverflow(long a, long b, long sum) {
        return ((a ^ sum) & (b ^ sum)) < 0L;
    }

    private static boolean diffHadOverflow(long a, long b, long diff) {
        return ((a ^ b) & (a ^ diff)) < 0L;
    }

    @Nullable
    public static <T> T checkSerializable(@Nullable T object, @Nonnull String objectName) {
        if (object == null) {
            return null;
        }
        if (object instanceof DataSerializable) {
            return object;
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("\"" + objectName + "\" must implement Serializable");
        }
        try (ObjectOutputStream os = new ObjectOutputStream(OutputStream.nullOutputStream());){
            os.writeObject(object);
        }
        catch (InvalidClassException | NotSerializableException e) {
            throw new IllegalArgumentException("\"" + objectName + "\" must be serializable", e);
        }
        catch (IOException e) {
            throw new JetException(e);
        }
        return object;
    }

    @Nonnull
    public static <T> T checkNonNullAndSerializable(@Nonnull T object, @Nonnull String objectName) {
        if (object == null) {
            throw new IllegalArgumentException("\"" + objectName + "\" must not be null");
        }
        Util.checkSerializable(object, objectName);
        return object;
    }

    public static <T> Map<Integer, List<T>> distributeObjects(int count, List<T> objects) {
        Map processorToObjects = IntStream.range(0, objects.size()).mapToObj(i2 -> com.hazelcast.jet.Util.entry(i2, objects.get(i2))).collect(Collectors.groupingBy(e -> (Integer)e.getKey() % count, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        for (int i3 = 0; i3 < count; ++i3) {
            processorToObjects.putIfAbsent(i3, Collections.emptyList());
        }
        return processorToObjects;
    }

    public static int[][] distributeObjects(int count, int[] objects) {
        int i2;
        int[][] processorToObjects = new int[count][];
        for (i2 = 0; i2 < count; ++i2) {
            processorToObjects[i2] = new int[objects.length / count + (objects.length % count > i2 ? 1 : 0)];
        }
        for (i2 = 0; i2 < objects.length; ++i2) {
            processorToObjects[i2 % count][i2 / count] = objects[i2];
        }
        return processorToObjects;
    }

    public static int[] roundRobinPart(int objectCount, int count, int index) {
        if (objectCount < 0 || index < 0 || count < 1 || index >= count) {
            throw new IllegalArgumentException("objectCount=" + objectCount + ", count=" + count + ", index=" + index);
        }
        int[] res = new int[objectCount / count + (objectCount % count > index ? 1 : 0)];
        int i2 = 0;
        for (int j = index; j < objectCount; j += count) {
            res[i2] = j;
            ++i2;
        }
        return res;
    }

    public static String jobNameAndExecutionId(String jobName, long executionId) {
        return "job '" + jobName + "', execution " + com.hazelcast.jet.Util.idToString(executionId);
    }

    public static String jobIdAndExecutionId(long jobId, long executionId) {
        return "job " + com.hazelcast.jet.Util.idToString(jobId) + ", execution " + com.hazelcast.jet.Util.idToString(executionId);
    }

    private static ZonedDateTime toZonedDateTime(long timestamp) {
        return Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long timestamp) {
        return Util.toZonedDateTime(timestamp).toLocalDateTime();
    }

    public static String toLocalTime(long timestamp) {
        return Util.toZonedDateTime(timestamp).toLocalTime().format(LOCAL_TIME_FORMATTER);
    }

    public static int arrayIndexOf(int needle, int[] haystack) {
        for (int i2 = 0; i2 < haystack.length; ++i2) {
            if (haystack[i2] != needle) continue;
            return i2;
        }
        return -1;
    }

    public static <T, R> T reduce(T identity, Stream<R> elements, BiFunction<T, R, T> accumulator) {
        T result = identity;
        for (Object element : elements::iterator) {
            result = accumulator.apply(result, element);
        }
        return result;
    }

    public static <T, R> T collect(T container, Stream<R> elements, BiConsumer<T, R> accumulator) {
        for (Object element : elements::iterator) {
            accumulator.accept(container, element);
        }
        return container;
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(@Nonnull Throwable exception) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(exception);
        return future;
    }

    public static void logLateEvent(ILogger logger, byte key, long currentWm, @Nonnull Object item) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        if (item instanceof JetEvent) {
            JetEvent event = (JetEvent)item;
            logger.info(String.format("Event dropped, late by %d ms. currentWatermark=%s, eventTime=%s, event=%s", currentWm - event.timestamp(), Util.toLocalTime(currentWm), Util.toLocalTime(event.timestamp()), event.payload()));
        } else {
            logger.info(String.format("Late event dropped. currentWatermark=%s, event=%s", new Watermark(currentWm, key), item));
        }
    }

    public static long gcd(long ... values) {
        long res = 0L;
        for (long value : values) {
            res = Util.gcd(res, value);
        }
        return res;
    }

    public static long gcd(long a, long b) {
        a = Math.abs(a);
        if ((b = Math.abs(b)) == 0L) {
            return a;
        }
        return Util.gcd(b, a % b);
    }

    public static void lazyIncrement(AtomicLongArray counters, int index) {
        Util.lazyAdd(counters, index, 1L);
    }

    public static void lazyAdd(AtomicLongArray counters, int index, long addend) {
        counters.lazySet(index, counters.get(index) + addend);
    }

    public static List<Integer> range(final int begin, final int end) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return begin + index;
            }

            @Override
            public int size() {
                return end - begin;
            }
        };
    }

    public static <E> int sum(Collection<E> collection, ToIntFunction<E> toIntF) {
        int sum = 0;
        for (E e : collection) {
            sum += toIntF.applyAsInt(e);
        }
        return sum;
    }

    public static <E> int sum(E[] array, ToIntFunction<E> toIntF, int size) {
        int sum = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            sum += toIntF.applyAsInt(array[i2]);
        }
        return sum;
    }

    public static String escapeGraphviz(String value) {
        return value.replace("\"", "\\\"");
    }

    public static CompletableFuture<Void> copyMapUsingJob(HazelcastInstance instance, int queueSize, String sourceMap, String targetMap) {
        DAG dag = new DAG();
        Vertex source = dag.newVertex("readMap(" + sourceMap + ")", SourceProcessors.readMapP(sourceMap));
        Vertex sink = dag.newVertex("writeMap(" + targetMap + ")", SinkProcessors.writeMapP(targetMap));
        dag.edge(Edge.between(source, sink).setConfig(new EdgeConfig().setQueueSize(queueSize)));
        JobConfig jobConfig = new JobConfig().setName("copy-" + sourceMap + "-to-" + targetMap);
        return instance.getJet().newJob(dag, jobConfig).getFuture();
    }

    public static String addOrIncrementIndexInName(String name) {
        Matcher m = TRAILING_NUMBER_PATTERN.matcher(name);
        int index = 2;
        if (m.matches()) {
            try {
                int newIndex = Integer.parseInt(m.group(2)) + 1;
                if (newIndex > 2) {
                    index = newIndex;
                    name = m.group(1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return name + "-" + index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithClassLoader(ClassLoader cl, RunnableEx action) {
        Thread currentThread = Thread.currentThread();
        ClassLoader previousCl = currentThread.getContextClassLoader();
        if (cl != null) {
            currentThread.setContextClassLoader(cl);
        }
        try {
            action.run();
        }
        finally {
            if (cl != null) {
                currentThread.setContextClassLoader(previousCl);
            }
        }
    }

    public static <T> T doWithClassLoader(ClassLoader cl, Callable<T> callable) {
        Thread currentThread = Thread.currentThread();
        ClassLoader previousCl = currentThread.getContextClassLoader();
        if (cl != null) {
            currentThread.setContextClassLoader(cl);
        }
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            if (cl != null) {
                currentThread.setContextClassLoader(previousCl);
            }
        }
    }

    public static ProcessingGuarantee min(ProcessingGuarantee g1, ProcessingGuarantee g2) {
        return g1.ordinal() < g2.ordinal() ? g1 : g2;
    }

    @Nonnull
    public static <T, R> List<R> toList(@Nonnull Collection<T> coll, @Nonnull Function<? super T, ? extends R> mapFn) {
        return coll.stream().map(mapFn).collect(Collectors.toList());
    }

    public static Properties mergeProps(Properties original, Properties newProperties) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)original);
        props.putAll((Map<?, ?>)newProperties);
        return props;
    }

    public static void setPosixFilePermissions(@Nonnull Path path, @Nonnull Set<PosixFilePermission> permissions) throws IOException {
        Set<String> supportedAttr = path.getFileSystem().supportedFileAttributeViews();
        if (supportedAttr.contains("posix")) {
            Files.setPosixFilePermissions(path, permissions);
        }
    }

    public static void editPermissions(@Nonnull Path path, @Nonnull Predicate<? super Set<PosixFilePermission>> editFn) throws IOException {
        Set<PosixFilePermission> perms = Files.getPosixFilePermissions(path, LinkOption.NOFOLLOW_LINKS);
        if (editFn.test(perms)) {
            Files.setPosixFilePermissions(path, perms);
        }
    }

    public static List<String> editPermissionsRecursively(@Nonnull Path basePath, @Nonnull Predicate<? super Set<PosixFilePermission>> editFn) throws IOException {
        ArrayList<String> filesNotMarked = new ArrayList<String>();
        try (Stream<Path> walk = Files.walk(basePath, new FileVisitOption[0]);){
            walk.forEach(path -> {
                try {
                    Util.editPermissions(path, editFn);
                }
                catch (Exception e) {
                    filesNotMarked.add(basePath.relativize((Path)path).toString());
                }
            });
        }
        return filesNotMarked;
    }

    @Nonnull
    public static String formatJobDuration(long durationMs) {
        if (durationMs == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        String sign = "";
        if (durationMs < 0L) {
            sign = "-";
            durationMs = -durationMs;
        }
        long millis = durationMs % 1000L;
        long seconds = (durationMs /= 1000L) % 60L;
        long minutes = (durationMs /= 60L) % 60L;
        long hours = (durationMs /= 60L) % 24L;
        String textUpToHours = String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, millis);
        return sign + (String)((durationMs /= 24L) > 0L ? durationMs + "d " : "") + textUpToHours;
    }

    @Nonnull
    public static Function<String[], String[]> createFieldProjection(@Nonnull String[] inputFields, @Nonnull List<String> outputFields) {
        if (outputFields.equals(Arrays.asList(inputFields))) {
            return i2 -> i2;
        }
        int[] simpleFieldMap = new int[outputFields.size()];
        Arrays.fill(simpleFieldMap, -1);
        for (int i3 = 0; i3 < inputFields.length; ++i3) {
            int index = outputFields.indexOf(inputFields[i3]);
            if (index < 0 || simpleFieldMap[index] != -1) continue;
            simpleFieldMap[index] = i3;
        }
        return row0 -> {
            String[] projectedRow = new String[simpleFieldMap.length];
            for (int i2 = 0; i2 < simpleFieldMap.length; ++i2) {
                if (simpleFieldMap[i2] < 0) continue;
                projectedRow[i2] = row0[simpleFieldMap[i2]];
            }
            return projectedRow;
        };
    }

    public static InternalSerializationService getSerializationService(HazelcastInstance instance) {
        if (instance instanceof HazelcastInstanceImpl) {
            HazelcastInstanceImpl hazelcastInstanceImpl = (HazelcastInstanceImpl)instance;
            return hazelcastInstanceImpl.getSerializationService();
        }
        if (instance instanceof HazelcastInstanceProxy) {
            HazelcastInstanceProxy hazelcastInstanceProxy = (HazelcastInstanceProxy)instance;
            return hazelcastInstanceProxy.getSerializationService();
        }
        if (instance instanceof HazelcastClientInstanceImpl) {
            HazelcastClientInstanceImpl hazelcastClientInstanceImpl = (HazelcastClientInstanceImpl)instance;
            return hazelcastClientInstanceImpl.getSerializationService();
        }
        if (instance instanceof HazelcastClientProxy) {
            HazelcastClientProxy hazelcastClientProxy = (HazelcastClientProxy)instance;
            return hazelcastClientProxy.getSerializationService();
        }
        throw new IllegalArgumentException("Could not access serialization service. Unsupported HazelcastInstance type:" + instance);
    }

    public static NodeEngineImpl getNodeEngine(HazelcastInstance instance) {
        return Util.getHazelcastInstanceImpl((HazelcastInstance)instance).node.nodeEngine;
    }

    public static HazelcastInstanceImpl getHazelcastInstanceImpl(HazelcastInstance instance) {
        if (instance instanceof HazelcastInstanceImpl) {
            HazelcastInstanceImpl hazelcastInstanceImpl = (HazelcastInstanceImpl)instance;
            return hazelcastInstanceImpl;
        }
        if (instance instanceof HazelcastInstanceProxy) {
            HazelcastInstanceProxy hazelcastInstanceProxy = (HazelcastInstanceProxy)instance;
            return hazelcastInstanceProxy.getOriginal();
        }
        throw new IllegalArgumentException("This method can be called only with member instances such as HazelcastInstanceImpl and HazelcastInstanceProxy, but not " + instance.getClass());
    }

    public static <T> Predicate<T> distinctBy(Function<? super T, ?> keyFn) {
        HashSet seen = new HashSet();
        return t -> seen.add(keyFn.apply(t));
    }

    public static MembersView getMembersView(NodeEngine nodeEngine) {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)nodeEngine.getClusterService();
        return clusterService.getMembershipManager().getMembersView();
    }

    public static void checkJetIsEnabled(NodeEngine nodeEngine) {
        if (!Util.isJetEnabled(nodeEngine)) {
            throw new JetDisabledException(JET_IS_DISABLED_MESSAGE);
        }
    }

    public static boolean isJetEnabled(NodeEngine nodeEngine) {
        return nodeEngine.getConfig().getJetConfig().isEnabled();
    }

    public static byte[] heapDataWithHash(int hash) {
        byte[] data = new byte[8];
        Bits.writeIntB(data, 0, hash);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HazelcastInstance createRemoteClient(ProcessorMetaSupplier.Context context, @Nullable String dataConnectionName, @Nullable String clientXml) {
        if (dataConnectionName != null) {
            HazelcastDataConnection dataConnection = context.dataConnectionService().getAndRetainDataConnection(dataConnectionName, HazelcastDataConnection.class);
            try {
                HazelcastInstance hazelcastInstance = dataConnection.getClient();
                return hazelcastInstance;
            }
            finally {
                dataConnection.release();
            }
        }
        assert (clientXml != null);
        return HazelcastClient.newHazelcastClient(ImdgUtil.asClientConfig(clientXml));
    }

    public static class Identity<T>
    implements IdentifiedDataSerializable,
    FunctionEx<T, T> {
        public static final Identity INSTANCE = new Identity();
        private static final long serialVersionUID = 1L;

        @Override
        public T apply(T t) {
            return t;
        }

        @Override
        public T applyEx(T t) {
            return t;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
        }

        @Override
        public int getFactoryId() {
            return FunctionsSerializerHook.F_ID;
        }

        @Override
        public int getClassId() {
            return 1;
        }
    }
}

