/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.record;

import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.record.ComponentReaderWriter;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactReader;
import java.lang.reflect.Constructor;

public final class JavaRecordReader {
    private final Constructor<?> recordConstructor;
    private final ComponentReaderWriter[] componentReaderWriters;

    public JavaRecordReader(Constructor<?> recordConstructor, ComponentReaderWriter[] componentReaderWriters) {
        this.recordConstructor = recordConstructor;
        this.componentReaderWriters = componentReaderWriters;
    }

    public Object readRecord(CompactReader compactReader, Schema schema) {
        Object[] components = new Object[this.componentReaderWriters.length];
        try {
            for (int i2 = 0; i2 < this.componentReaderWriters.length; ++i2) {
                components[i2] = this.componentReaderWriters[i2].readComponent(compactReader, schema);
            }
            return this.recordConstructor.newInstance(components);
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Failed to read the Java record", e);
        }
    }
}

