/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.MetricConsumer;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.metrics.impl.DefaultMetricDescriptorSupplier;
import com.hazelcast.internal.metrics.impl.LongWordException;
import com.hazelcast.internal.metrics.impl.MetricsDictionary;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;

public class MetricsCompressor {
    static final int UNSIGNED_BYTE_MAX_VALUE = 255;
    private static final int INITIAL_BUFFER_SIZE_METRICS = 4096;
    private static final int INITIAL_BUFFER_SIZE_DICTIONARY = 2048;
    private static final int INITIAL_BUFFER_SIZE_DESCRIPTION = 512;
    private static final int SIZE_FACTOR_NUMERATOR = 11;
    private static final int SIZE_FACTOR_DENOMINATOR = 10;
    private static final int MASK_PREFIX = 1;
    private static final int MASK_METRIC = 2;
    private static final int MASK_DISCRIMINATOR = 4;
    private static final int MASK_DISCRIMINATOR_VALUE = 8;
    private static final int MASK_UNIT = 16;
    private static final int MASK_EXCLUDED_TARGETS = 32;
    private static final int MASK_TAG_COUNT = 64;
    private static final int BITS_IN_BYTE = 8;
    private static final int BYTE_MASK = 255;
    private static final short BINARY_FORMAT_VERSION = 1;
    private static final int NULL_DICTIONARY_ID = -1;
    private static final int NULL_UNIT = -1;
    private static final int SIZE_VERSION = 2;
    private static final int SIZE_DICTIONARY_BLOB = 4;
    private static final int SIZE_COUNT_METRICS = 4;
    private MetricsDictionary dictionary;
    @Nonnull
    private DataOutputStream dictionaryDos;
    @Nonnull
    private Deflater dictionaryCompressor;
    private MorePublicByteArrayOutputStream dictionaryBaos = new MorePublicByteArrayOutputStream(2048);
    @Nonnull
    private DataOutputStream metricDos;
    @Nonnull
    private Deflater metricsCompressor;
    private MorePublicByteArrayOutputStream metricBaos = new MorePublicByteArrayOutputStream(4096);
    private final DataOutputStream tmpDos;
    private final MorePublicByteArrayOutputStream tmpBaos = new MorePublicByteArrayOutputStream(512);
    private int count;
    private MetricDescriptor lastDescriptor;

    public MetricsCompressor() {
        this.reset(2048, 4096);
        this.tmpDos = new DataOutputStream(this.tmpBaos);
    }

    public void addLong(MetricDescriptor descriptor, long value) throws LongWordException {
        try {
            this.tmpBaos.reset();
            this.writeDescriptor(descriptor);
            this.tmpDos.writeByte(ValueType.LONG.ordinal());
            this.tmpDos.writeLong(value);
            this.metricDos.write(this.tmpBaos.internalBuffer(), 0, this.tmpBaos.size());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addDouble(MetricDescriptor descriptor, double value) throws LongWordException {
        try {
            this.tmpBaos.reset();
            this.writeDescriptor(descriptor);
            this.tmpDos.writeByte(ValueType.DOUBLE.ordinal());
            this.tmpDos.writeDouble(value);
            this.metricDos.write(this.tmpBaos.internalBuffer(), 0, this.tmpBaos.size());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDescriptor(MetricDescriptor originalDescriptor) throws IOException, LongWordException {
        MetricDescriptor descriptor = this.prepareDescriptor(originalDescriptor);
        int mask = this.calculateDescriptorMask(descriptor);
        this.tmpDos.writeByte(mask);
        if ((mask & 1) == 0) {
            this.tmpDos.writeInt(this.getDictionaryId(descriptor.prefix()));
        }
        if ((mask & 2) == 0) {
            this.tmpDos.writeInt(this.getDictionaryId(descriptor.metric()));
        }
        if ((mask & 4) == 0) {
            this.tmpDos.writeInt(this.getDictionaryId(descriptor.discriminator()));
        }
        if ((mask & 8) == 0) {
            this.tmpDos.writeInt(this.getDictionaryId(descriptor.discriminatorValue()));
        }
        if ((mask & 0x10) == 0) {
            ProbeUnit unit = descriptor.unit();
            if (unit != null) {
                this.tmpDos.writeByte(unit.ordinal());
            } else {
                this.tmpDos.writeByte(-1);
            }
        }
        if ((mask & 0x20) == 0) {
            this.tmpDos.writeByte(MetricTarget.bitset(descriptor.excludedTargets()));
        }
        if ((mask & 0x40) == 0) {
            this.tmpDos.writeByte(descriptor.tagCount());
        }
        for (int i2 = 0; i2 < descriptor.tagCount(); ++i2) {
            String tag = descriptor.tag(i2);
            String tagValue = descriptor.tagValue(i2);
            this.tmpDos.writeInt(this.getDictionaryId(tag));
            this.tmpDos.writeInt(this.getDictionaryId(tagValue));
        }
        ++this.count;
        this.lastDescriptor = MetricsCompressor.copyDescriptor(descriptor, this.lastDescriptor);
    }

    private MetricDescriptor prepareDescriptor(MetricDescriptor descriptor) {
        ProbeUnit unit = descriptor.unit();
        if (unit == null || !unit.isNewUnit()) {
            return descriptor;
        }
        return descriptor.copy().withTag("metric-unit", unit.name()).withUnit(null);
    }

    private int calculateDescriptorMask(MetricDescriptor descriptor) {
        int mask = 0;
        if (this.lastDescriptor != null) {
            if (Objects.equals(descriptor.prefix(), this.lastDescriptor.prefix())) {
                mask |= 1;
            }
            if (Objects.equals(descriptor.metric(), this.lastDescriptor.metric())) {
                mask |= 2;
            }
            if (Objects.equals(descriptor.discriminator(), this.lastDescriptor.discriminator())) {
                mask |= 4;
            }
            if (Objects.equals(descriptor.discriminatorValue(), this.lastDescriptor.discriminatorValue())) {
                mask |= 8;
            }
            if (descriptor.unit() == this.lastDescriptor.unit()) {
                mask |= 0x10;
            }
            if (Objects.equals(descriptor.excludedTargets(), this.lastDescriptor.excludedTargets())) {
                mask |= 0x20;
            }
            if (descriptor.tagCount() == this.lastDescriptor.tagCount()) {
                mask |= 0x40;
            }
        }
        return mask;
    }

    private static MetricDescriptor copyDescriptor(MetricDescriptor from, MetricDescriptor to) {
        MetricDescriptor target = to != null ? to : (MetricDescriptor)DefaultMetricDescriptorSupplier.DEFAULT_DESCRIPTOR_SUPPLIER.get();
        return target.copy(from);
    }

    private int getDictionaryId(String word) {
        if (word == null) {
            return -1;
        }
        return this.dictionary.getDictionaryId(word);
    }

    public byte[] getBlobAndReset() {
        byte[] blob = this.getRenderedBlob();
        int estimatedBytesDictionary = this.dictionaryBaos.size() * 11 / 10;
        int estimatedBytesMetrics = this.metricBaos.size() * 11 / 10;
        this.reset(estimatedBytesDictionary, estimatedBytesMetrics);
        return blob;
    }

    public byte[] getBlobAndClose() {
        return this.getRenderedBlob();
    }

    private void writeDictionary() throws IOException {
        Collection<MetricsDictionary.Word> words = this.dictionary.words();
        this.dictionaryDos.writeInt(words.size());
        String lastWord = "";
        for (MetricsDictionary.Word word : words) {
            int commonLen;
            this.tmpBaos.reset();
            String wordText = word.word();
            if (wordText.length() > 255) {
                throw new RuntimeException("Dictionary element too long: " + wordText);
            }
            int maxCommonLen = Math.min(lastWord.length(), wordText.length());
            for (commonLen = 0; commonLen < maxCommonLen && wordText.charAt(commonLen) == lastWord.charAt(commonLen); ++commonLen) {
            }
            int diffLen = wordText.length() - commonLen;
            this.tmpDos.writeInt(word.dictionaryId());
            this.tmpDos.writeByte(commonLen);
            this.tmpDos.writeByte(diffLen);
            for (int i2 = commonLen; i2 < wordText.length(); ++i2) {
                this.tmpDos.writeChar(wordText.charAt(i2));
            }
            lastWord = wordText;
            this.dictionaryDos.write(this.tmpBaos.internalBuffer(), 0, this.tmpBaos.size());
        }
    }

    public int count() {
        return this.count;
    }

    private void reset(int estimatedBytesDictionary, int estimatedBytesMetrics) {
        this.dictionaryCompressor = new Deflater();
        this.dictionaryCompressor.setLevel(1);
        if (this.dictionaryBaos.capacity() > Math.multiplyExact(estimatedBytesDictionary, 3) / 2) {
            this.dictionaryBaos = new MorePublicByteArrayOutputStream(estimatedBytesDictionary);
        }
        this.dictionaryBaos.reset();
        this.dictionaryDos = new DataOutputStream(new DeflaterOutputStream((OutputStream)this.dictionaryBaos, this.dictionaryCompressor));
        this.metricsCompressor = new Deflater();
        this.metricsCompressor.setLevel(1);
        if (this.metricBaos.capacity() > Math.multiplyExact(estimatedBytesMetrics, 3) / 2) {
            this.metricBaos = new MorePublicByteArrayOutputStream(estimatedBytesMetrics);
        }
        this.metricBaos.reset();
        this.metricDos = new DataOutputStream(new DeflaterOutputStream((OutputStream)this.metricBaos, this.metricsCompressor));
        this.dictionary = new MetricsDictionary();
        this.count = 0;
        this.lastDescriptor = null;
    }

    public void close() {
        try {
            this.dictionaryDos.close();
            this.dictionaryCompressor.end();
            this.metricDos.close();
            this.metricsCompressor.end();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getRenderedBlob() {
        try {
            this.writeDictionary();
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] dictionaryBytes = this.dictionaryBaos.toByteArray();
        byte[] metricsBytes = this.metricBaos.toByteArray();
        int completeSize = 6 + dictionaryBytes.length + 4 + metricsBytes.length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(completeSize);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.write(0);
            dos.write(1);
            dos.writeInt(dictionaryBytes.length);
            dos.write(dictionaryBytes);
            dos.writeInt(this.count);
            dos.write(metricsBytes);
            dos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static void extractMetrics(byte[] blob, MetricConsumer consumer) {
        MetricsCompressor.extractMetrics(blob, consumer, DefaultMetricDescriptorSupplier.DEFAULT_DESCRIPTOR_SUPPLIER);
    }

    @SuppressFBWarnings(value={"RR_NOT_CHECKED"})
    public static void extractMetrics(byte[] blob, MetricConsumer consumer, Supplier<? extends MetricDescriptor> supplier) {
        ByteArrayInputStream bais = new ByteArrayInputStream(blob);
        int version = (bais.read() << 8) + bais.read();
        if (version != 1) {
            throw new RuntimeException("Incorrect format, expected version 1, got " + version);
        }
        DataInputStream dis = new DataInputStream(bais);
        try {
            int dictionaryBlobSize = dis.readInt();
            byte[] dictionaryBlob = new byte[dictionaryBlobSize];
            dis.read(dictionaryBlob);
            int countMetrics = dis.readInt();
            int metricsBlobSize = blob.length - 2 - 4 - dictionaryBlobSize - 4;
            byte[] metricsBlob = new byte[metricsBlobSize];
            dis.read(metricsBlob);
            dis.close();
            String[] dictionary = MetricsCompressor.readDictionary(dictionaryBlob);
            new MetricsDecompressor(metricsBlob, countMetrics, dictionary, supplier, consumer).extractMetrics();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String[] readDictionary(byte[] dictionaryBlob) throws IOException {
        try (DataInputStream dis = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(dictionaryBlob)));){
            int dictionarySize = dis.readInt();
            String[] dictionary = new String[dictionarySize];
            String lastWord = "";
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < dictionarySize; ++i2) {
                String readWord;
                int dictionaryId = dis.readInt();
                int commonLen = dis.readUnsignedByte();
                int diffLen = dis.readUnsignedByte();
                sb.append(lastWord, 0, commonLen);
                for (int j = 0; j < diffLen; ++j) {
                    sb.append(dis.readChar());
                }
                lastWord = readWord = sb.toString();
                dictionary[dictionaryId] = readWord;
                sb.setLength(0);
            }
            String[] stringArray = dictionary;
            return stringArray;
        }
    }

    private static class MorePublicByteArrayOutputStream
    extends ByteArrayOutputStream {
        MorePublicByteArrayOutputStream(int size) {
            super(size);
        }

        int capacity() {
            return this.buf.length;
        }

        byte[] internalBuffer() {
            return this.buf;
        }
    }

    static enum ValueType {
        LONG,
        DOUBLE;

        private static final ValueType[] VALUE_TYPES;

        public static ValueType valueOf(int ordinal) {
            try {
                return VALUE_TYPES[ordinal];
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unexpected ordinal value for ValueType: " + ordinal);
            }
        }

        static {
            VALUE_TYPES = ValueType.values();
        }
    }

    private static final class MetricsDecompressor {
        private final int countMetrics;
        private final MetricConsumer consumer;
        private final String[] dictionary;
        private final DataInputStream dis;
        private final Supplier<? extends MetricDescriptor> supplier;
        private final MetricDescriptor lastDescriptor;
        private final ProbeUnit[] units = ProbeUnit.values();

        private MetricsDecompressor(byte[] metricsBlob, int countMetrics, String[] dictionary, Supplier<? extends MetricDescriptor> supplier, MetricConsumer consumer) {
            this.countMetrics = countMetrics;
            this.consumer = consumer;
            this.dictionary = dictionary;
            this.dis = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(metricsBlob)));
            this.supplier = supplier;
            this.lastDescriptor = DefaultMetricDescriptorSupplier.DEFAULT_DESCRIPTOR_SUPPLIER.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void extractMetrics() throws IOException {
            try {
                block7: for (int i2 = 0; i2 < this.countMetrics; ++i2) {
                    MetricDescriptor descriptor = this.readMetricDescriptor();
                    this.lastDescriptor.copy(descriptor);
                    int typeOrdinal = this.dis.readUnsignedByte();
                    ValueType type = ValueType.valueOf(typeOrdinal);
                    switch (type) {
                        case LONG: {
                            this.consumer.consumeLong(descriptor, this.dis.readLong());
                            continue block7;
                        }
                        case DOUBLE: {
                            this.consumer.consumeDouble(descriptor, this.dis.readDouble());
                            continue block7;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected metric value type: " + type + " with ordinal " + typeOrdinal);
                        }
                    }
                }
            }
            finally {
                this.dis.close();
            }
        }

        private MetricDescriptor readMetricDescriptor() throws IOException {
            int mask = this.dis.readUnsignedByte();
            MetricDescriptor descriptor = this.supplier.get();
            this.fillPrefix(descriptor, mask);
            this.fillMetric(descriptor, mask);
            this.fillDiscriminator(descriptor, mask);
            this.fillUnit(descriptor, mask);
            this.fillExcludedTargets(descriptor, mask);
            this.fillTags(descriptor, mask);
            return descriptor;
        }

        private void fillPrefix(MetricDescriptor descriptor, int mask) throws IOException {
            if ((mask & 1) != 0) {
                descriptor.withPrefix(this.lastDescriptor.prefix());
            } else {
                descriptor.withPrefix(this.readNextWord());
            }
        }

        private void fillMetric(MetricDescriptor descriptor, int mask) throws IOException {
            if ((mask & 2) != 0) {
                descriptor.withMetric(this.lastDescriptor.metric());
            } else {
                descriptor.withMetric(this.readNextWord());
            }
        }

        private void fillDiscriminator(MetricDescriptor descriptor, int mask) throws IOException {
            String discriminator = (mask & 4) != 0 ? this.lastDescriptor.discriminator() : this.readNextWord();
            String discriminatorValue = (mask & 8) != 0 ? this.lastDescriptor.discriminatorValue() : this.readNextWord();
            descriptor.withDiscriminator(discriminator, discriminatorValue);
        }

        private void fillUnit(MetricDescriptor descriptor, int mask) throws IOException {
            if ((mask & 0x10) != 0) {
                descriptor.withUnit(this.lastDescriptor.unit());
            } else {
                byte unitOrdinal = this.dis.readByte();
                ProbeUnit unit = unitOrdinal != -1 && unitOrdinal < this.units.length ? this.units[unitOrdinal] : null;
                descriptor.withUnit(unit);
            }
        }

        private void fillExcludedTargets(MetricDescriptor descriptor, int mask) throws IOException {
            if ((mask & 0x20) != 0) {
                descriptor.withExcludedTargets(this.lastDescriptor.excludedTargets());
            } else {
                byte excludedMetricsBitset = this.dis.readByte();
                descriptor.withExcludedTargets(MetricTarget.asSet(excludedMetricsBitset));
            }
        }

        private void fillTags(MetricDescriptor descriptor, int mask) throws IOException {
            int tagCount = (mask & 0x40) != 0 ? this.lastDescriptor.tagCount() : this.dis.readUnsignedByte();
            for (int i2 = 0; i2 < tagCount; ++i2) {
                int tagId = this.dis.readInt();
                int tagValueId = this.dis.readInt();
                String tag = this.dictionary[tagId];
                String tagValue = this.dictionary[tagValueId];
                descriptor.withTag(tag, tagValue);
            }
        }

        private String readNextWord() throws IOException {
            int dictionaryId = this.dis.readInt();
            return dictionaryId != -1 ? this.dictionary[dictionaryId] : null;
        }
    }
}

