/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ListIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListUUIDCodec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class EntryListUUIDListIntegerCodec {
    private EntryListUUIDListIntegerCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Map.Entry<UUID, List<Integer>>> collection) {
        ArrayList<UUID> keyList = new ArrayList<UUID>(collection.size());
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        for (Map.Entry<UUID, List<Integer>> entry : collection) {
            keyList.add(entry.getKey());
            ListIntegerCodec.encode(clientMessage, (Collection<Integer>)entry.getValue());
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
        ListUUIDCodec.encode(clientMessage, keyList);
    }

    public static List<Map.Entry<UUID, List<Integer>>> decode(ClientMessage.ForwardFrameIterator iterator) {
        List<List> listv = ListMultiFrameCodec.decode(iterator, ListIntegerCodec::decode);
        List<UUID> listK = ListUUIDCodec.decode(iterator);
        ArrayList<Map.Entry<UUID, List<Integer>>> result = new ArrayList<Map.Entry<UUID, List<Integer>>>(listK.size());
        for (int i2 = 0; i2 < listK.size(); ++i2) {
            result.add(new AbstractMap.SimpleEntry<UUID, List>(listK.get(i2), listv.get(i2)));
        }
        return result;
    }
}

