/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleGauge;
import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.impl.AbstractGauge;
import com.hazelcast.internal.metrics.impl.MetricValueCatcher;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.impl.ProbeInstance;

class DoubleGaugeImpl
extends AbstractGauge
implements DoubleGauge {
    static final double DEFAULT_VALUE = 0.0;
    private volatile DoubleGaugeSource gaugeSource;

    DoubleGaugeImpl(MetricsRegistryImpl metricsRegistry, String name) {
        super(metricsRegistry, name);
        ProbeInstance probeInstance = metricsRegistry.getProbeInstance(name);
        this.gaugeSource = probeInstance != null ? new ProbeInstanceGaugeSource(probeInstance) : new DoubleMetricValueCatcher();
    }

    @Override
    public void onProbeInstanceSet(ProbeInstance probeInstance) {
        this.gaugeSource = new ProbeInstanceGaugeSource(probeInstance);
    }

    @Override
    MetricValueCatcher getCatcherOrNull() {
        DoubleMetricValueCatcher dmvc;
        DoubleGaugeSource gaugeSourceCopy = this.gaugeSource;
        return gaugeSourceCopy instanceof DoubleMetricValueCatcher ? (dmvc = (DoubleMetricValueCatcher)gaugeSourceCopy) : null;
    }

    @Override
    public double read() {
        return this.gaugeSource.read();
    }

    @Override
    public void render(StringBuilder stringBuilder) {
        stringBuilder.append(this.read());
    }

    private static double getMetricValue(String gaugeName, Object source, ProbeFunction function, MetricsRegistryImpl metricsRegistry) {
        try {
            if (function instanceof LongProbeFunction) {
                LongProbeFunction longFunction = (LongProbeFunction)function;
                return longFunction.get(source);
            }
            DoubleProbeFunction doubleFunction = (DoubleProbeFunction)function;
            return doubleFunction.get(source);
        }
        catch (Exception e) {
            metricsRegistry.logger.warning("Failed to access the probe: " + gaugeName, e);
            return 0.0;
        }
    }

    private final class ProbeInstanceGaugeSource
    implements DoubleGaugeSource {
        private volatile ProbeInstance probeInstance;

        private ProbeInstanceGaugeSource(ProbeInstance probeInstance) {
            this.probeInstance = probeInstance;
        }

        @Override
        public double read() {
            ProbeFunction function = null;
            Object source = null;
            if (this.probeInstance != null) {
                function = this.probeInstance.function;
                source = this.probeInstance.source;
            }
            if (function == null || source == null) {
                this.probeInstance = null;
                return 0.0;
            }
            return DoubleGaugeImpl.getMetricValue(DoubleGaugeImpl.this.name, source, function, DoubleGaugeImpl.this.metricsRegistry);
        }
    }

    private static interface DoubleGaugeSource {
        public double read();
    }

    private final class DoubleMetricValueCatcher
    extends AbstractGauge.AbstractMetricValueCatcher
    implements DoubleGaugeSource {
        private volatile double value = 0.0;

        private DoubleMetricValueCatcher() {
        }

        @Override
        public void catchMetricValue(long collectionId, long value) {
            DoubleGaugeImpl.this.lastCollectionId = collectionId;
            this.value = value;
            this.clearCachedMetricSourceRef();
        }

        @Override
        public void catchMetricValue(long collectionId, double value) {
            DoubleGaugeImpl.this.lastCollectionId = collectionId;
            this.value = value;
            this.clearCachedMetricSourceRef();
        }

        @Override
        public double read() {
            return this.readBase(DoubleGaugeImpl::getMetricValue, () -> this.value);
        }

        @Override
        void clearCachedValue() {
            this.value = 0.0;
        }
    }
}

