/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.imap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.ParseException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.AuthenticationProxy;
import net.messagevortex.transport.Credentials;
import net.messagevortex.transport.SecurityContext;
import net.messagevortex.transport.imap.ImapClient;
import net.messagevortex.transport.imap.ImapServer;

public class ImapPassthruServer {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static final String imapUrl = "(?<protocol>imap[s]?)://(?:(?<username>[\\p{Alnum}\\-\\.]+):(?<password>[\\p{ASCII}&&[^@]]+)@)?(?<server>[\\p{Alnum}\\.\\-]+)(?::(?<port>[\\digit]{1,5}))?";
    private final ImapServer localServer;
    private final ImapClient remoteServer;

    public ImapPassthruServer(InetSocketAddress listeningAddress, SecurityContext context, Credentials listeningCredentials, InetSocketAddress forwardingServer, Credentials forwardingCredentials) throws IOException {
        this.localServer = new ImapServer(listeningAddress, context);
        AuthenticationProxy authProxy = new AuthenticationProxy();
        authProxy.addCredentials(listeningCredentials);
        this.localServer.setAuth(authProxy);
        this.remoteServer = new ImapClient(forwardingServer, context);
    }

    public void shutdown() throws IOException {
        this.localServer.shutdown();
        this.remoteServer.shutdown();
    }

    public static String getUsernameFromUrl(String url) throws ParseException {
        if (url == null) {
            throw new NullPointerException("Address may not be null");
        }
        Pattern p = Pattern.compile(imapUrl);
        Matcher m = p.matcher(url);
        if (!m.matches()) {
            throw new ParseException("Unable to parse imap URL \"" + url + "\"", -1);
        }
        return m.group("username");
    }

    public static String getPasswordFromUrl(String url) throws ParseException {
        if (url == null) {
            throw new NullPointerException("Address may not be null");
        }
        Pattern p = Pattern.compile(imapUrl);
        Matcher m = p.matcher(url);
        if (!m.matches()) {
            throw new ParseException("Unable to parse imap URL \"" + url + "\"", -1);
        }
        return m.group("password");
    }

    public static String getProtocolFromUrl(String url) throws ParseException {
        if (url == null) {
            throw new NullPointerException("Address may not be null");
        }
        Pattern p = Pattern.compile(imapUrl);
        Matcher m = p.matcher(url);
        if (!m.matches()) {
            throw new ParseException("Unable to parse imap URL \"" + url + "\"", -1);
        }
        return m.group("protocol");
    }

    public static int getPortFromUrl(String url) throws ParseException {
        if (url == null) {
            throw new NullPointerException("Address may not be null");
        }
        Pattern p = Pattern.compile(imapUrl);
        Matcher m = p.matcher(url);
        if (!m.matches()) {
            throw new ParseException("Unable to parse imap URL \"" + url + "\"", -1);
        }
        return m.group("port") == null ? -1 : Integer.parseInt(m.group("port"));
    }

    public static InetSocketAddress getSocketAddressFromUrl(String url) throws ParseException {
        if (url == null) {
            throw new NullPointerException("Address may not be null");
        }
        Pattern p = Pattern.compile(imapUrl);
        Matcher m = p.matcher(url);
        if (!m.matches()) {
            throw new ParseException("Unable to parse imap URL \"" + url + "\"", -1);
        }
        String host = m.group("server");
        int port = m.group("port") != null ? Integer.parseInt(m.group("port")) : ("imaps".equals(m.group("protocol")) ? 993 : 143);
        return new InetSocketAddress(host, port);
    }
}

