/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;

public class MessageVortexController {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static final Object runningLock = new Object();
    private static final int port = 8743;
    private static final ControllerRunner runner = new ControllerRunner();
    private Timer timer = null;

    public MessageVortexController() {
        Thread t = new Thread(runner);
        t.setName("MessageVortexShutdownController:8743");
        runner.setThread(t);
        t.start();
    }

    public void waitForShutdown() {
        runner.waitForShutdown();
    }

    public synchronized void setTimeout(long milliSeconds) {
        if (milliSeconds < 0L) {
            return;
        }
        LOGGER.log(Level.INFO, "MessageVortex controller sets timeout to " + milliSeconds / 1000L + " s");
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                runner.shutdown();
            }
        }, milliSeconds);
    }

    private static class ControllerRunner
    implements Runnable {
        private boolean shutdown = false;
        private Thread runner = null;

        private ControllerRunner() {
        }

        public Thread getThread() {
            return this.runner;
        }

        public void setThread(Thread t) {
            this.runner = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shutdown = false;
            while (!shutdown) {
                try {
                    ServerSocket serverConnection = new ServerSocket(8743);
                    LOGGER.log(Level.INFO, "MessageVortex controller waits for command");
                    Socket s = serverConnection.accept();
                    String command = new BufferedReader(new InputStreamReader(s.getInputStream(), StandardCharsets.UTF_8)).readLine();
                    LOGGER.log(Level.INFO, "MessageVortex controller got command \"" + command + "\"");
                    if (command == null) {
                        LOGGER.log(Level.INFO, "MessageVortex controller skips empty command line");
                        s.getOutputStream().write("ERROR got empty command\r\n".getBytes(StandardCharsets.UTF_8));
                    } else if (command.toLowerCase().startsWith("shutdown")) {
                        LOGGER.log(Level.INFO, "MessageVortex controller executes shutdown command");
                        shutdown = true;
                        s.getOutputStream().write("OK\r\n".getBytes(StandardCharsets.UTF_8));
                    } else if (command.toLowerCase().startsWith("status")) {
                        LOGGER.log(Level.INFO, "MessageVortex controller executes status command");
                        s.getOutputStream().write("OK\r\n## Status for all components are green\r\n".getBytes(StandardCharsets.UTF_8));
                    } else {
                        LOGGER.log(Level.WARNING, "MessageVortex controller got illegal command \"" + command + "\"");
                        s.getOutputStream().write("ERROR unknown command\r\n".getBytes(StandardCharsets.UTF_8));
                    }
                    s.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.FINE, "Exception while listening/processing controller connection", ioe);
                }
                Object object = runningLock;
                synchronized (object) {
                    shutdown = this.shutdown || shutdown;
                }
            }
        }

        public void waitForShutdown() {
            while (this.runner.isAlive()) {
                try {
                    this.runner.join();
                }
                catch (InterruptedException ie) {
                    LOGGER.log(Level.FINEST, "ignoring interrupted exception while waiting for shutdown", ie);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = runningLock;
            synchronized (object) {
                this.shutdown = true;
                try {
                    Socket s = new Socket(InetAddress.getLoopbackAddress().getHostAddress(), 8743);
                    s.getOutputStream().write("shutdown\r\n".getBytes(StandardCharsets.UTF_8));
                    s.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "IOException while waking up thread for shutdown", ioe);
                }
            }
            this.waitForShutdown();
        }
    }
}

